	function N = MIN_PHASE_LP_FIR_ORDER(wT, d)
 
	%	Uses Herrmanns estimate of the required order for a corresponding   
	%	minimax designed linear-phase lowpass FIR filters to estimate the 
	% 	required order for a minimum-phase FIR filter.
	%
	%   inputs:
	%	  wT = [wcT wsT]
	%     wcT: passband cutoff edge (NORMALIZED 0 < wcT < )
	%     wsT: stopband cutoff edge > wcT 
	%	  d = [dc ds]
	%     dc: passband ripple 
	%     ds: stopband ripple < dc
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar 2005-07-06
	% 	Modified by: 	 	
	% 	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:		
	% 	Report bugs to:		Wanhammar@gmail.com
 
	x = 2 + 2*d(1)^2 - d(2)^2;
	dLP = [4*d(1)/x d(2)^2/x];
	[N, Be, D, W] = HERRMANN_LP_FIR_ORDER(wT, dLP);
	N = ceil(0.5*N + 0.5);
	%	N =  0.5*N + 0.5;   % Used in FIGURE 5.35

